/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.mixed;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableObserver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.CompletableSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.MaybeSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.SingleSource;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Supplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.maybe.MaybeToObservable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.single.SingleToObservable;
import java.util.Objects;

final class ScalarXMapZHelper {
    private ScalarXMapZHelper() {
        throw new IllegalStateException("No instances!");
    }

    static <T> boolean tryAsCompletable(Object source, Function<? super T, ? extends CompletableSource> mapper, CompletableObserver observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            CompletableSource cs = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null CompletableSource");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (cs == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs.subscribe(observer);
            }
            return true;
        }
        return false;
    }

    static <T, R> boolean tryAsMaybe(Object source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, Observer<? super R> observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            MaybeSource<R> cs = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null MaybeSource");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (cs == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs.subscribe(MaybeToObservable.create(observer));
            }
            return true;
        }
        return false;
    }

    static <T, R> boolean tryAsSingle(Object source, Function<? super T, ? extends SingleSource<? extends R>> mapper, Observer<? super R> observer) {
        if (source instanceof Supplier) {
            Supplier supplier = (Supplier)source;
            SingleSource<R> cs = null;
            try {
                Object item = supplier.get();
                if (item != null) {
                    cs = Objects.requireNonNull(mapper.apply(item), "The mapper returned a null SingleSource");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (cs == null) {
                EmptyDisposable.complete(observer);
            } else {
                cs.subscribe(SingleToObservable.create(observer));
            }
            return true;
        }
        return false;
    }
}

